% An example showing how to set up ChirpLab to run
% a certain number of simulations.
disp('--Running RunSimsDemo.m--');

% signal length
N = 2^6;

% initialize chirplet graph using the default settings
disp('Initializing chirplet graph...');
graphparam = GetChirpletGraphParam(N);

% Use the best path statistic with lengths 1,2,3,4
statType = 'BP';
statParam = 4;

% number of simulations
numSims = 10;

% wrap the experiment setup
expSetup = ExperimentSetup(graphparam,statType,statParam,numSims);

% file name to store the data
fname = 'nullRunSimsDemo.mat';

% the random seed to use
randSeed = 1234;

% run the simulations
disp('Running the simulations (this might take awhile)...');
T = RunSimulations(expSetup,fname,randSeed);
disp('Done!');
