function C = ChirpletAnalysis(sig,deep)
% ChirpletAnalysis -- Chirplet Transform
%  Usage
%    C = ChirpletAnalysis(sig);
%  Input
%    sig     signal of length n
%    deep    finest dyadic scale: 2^deep <= n/2
%  Outputs
%    C       chirplet coefficients

        [n,J] = dyadlength(sig);
	
if nargin < 2,
	deep = J - 1;
end
       nn = 2*2^deep - 1;

%      Create data structure

       C = cell(1,nn-1);
       
%      Calculate chirplet coefficients

       symmetricSlopes = 0; % no symmetric slopes
       C{node(0,0)} = ChirpTransInt(sig,n,symmetricSlopes);
       
       for s = 1:deep,
	 for b = 0:(2^s-1),
	   maxdepth = (s == deep);
	   C{node(s,b)} = ChirpletCoeffOnInterval(sig,s,b,maxdepth);
	 end
       end
       
% Copyright (c) 2003 Emmanuel J. Candes
