function c = ChirpletCoeffOnInterval(sig,s,b,max_depth)
% ChirpTransInt -- Chirplet Transform of a Dyadic Interval
%  Usage
%   c = ChirpletCoeffOnInterval(x,s,b);
%  Input
%    sig   original signal
%    s     depth 
%    b     interval index
%    max_depth 0/1  
%  Outputs
%    c       chirplet coefficients

if nargin < 4,
	max_depth = 0;
end

        n = length(sig);
        ns = n/2^s; ns2 = ns/2;
	js = log2(ns);
	
	low = b*ns + 1 - ns2; hi = (b+1)*ns + ns2;
	index = low:hi;
	if (b == 0 || b == 2^s -1)
	  index = CircularWrap(low:hi,n);
	end
	x = sig(index);
		
	slopes = (0:(ns-1))/ns - 1/2;
	t = -ns2:(3*ns2-1);
	
	if max_depth == 0,
	  c = zeros(2*ns,ns,2,2);
	  for alpha = 0:1,
	    for beta = 0:1,
	      w = MakeIterSineWindow(js,[alpha beta]);
	      X = repmat(x.*w,ns,1) .* exp(-i*pi*slopes.'*t.^2/n);
	      c(:,:,alpha+1,beta+1) = fft(X.')/sqrt(2*ns);
	    end 
	  end 
	  else
	    c = zeros(2*ns,ns);
	    w = MakeIterSineWindow(js,[0 0]);
	    X = repmat(x.*w,ns,1) .* exp(-i*pi*slopes.'*t.^2/n);
	    c = fft(X.')/sqrt(2*ns);
end

% Copyright (c) 2003 Emmanuel J. Candes
