function [ctree,stree] = CostChirpletTree(ch,lambda)

       deep = length(ch) -1;    
       n = size(ch{node(0,0)},1);
       deep = log2(length(ch) + 1) -1; 

       ctree = zeros(2,2,2*2^deep-1);
       stree = ctree;    

       for s = 0:deep,
	 for b = 0:(2^s - 1),
	    c = abs(ch{node(s,b)}).^2;
	    [ent, slope] = min(sum(min(c,lambda)));
	    
	    if (s == 0 || s == deep)
	      ctree(:,:,node(s,b)) = Inf; ctree(1,1,node(s,b)) = ent; 
              stree(:,:,node(s,b)) = Inf; stree(1,1,node(s,b)) = slope;
            else
	      ctree(:,:,node(s,b)) = ent; 
	      stree(:,:,node(s,b)) = slope;
	    end
	    
	 end
       end
       
	 
	 
% Copyright (c) Emmanuel Candes and Hannes Helgason, California Institute of Technology, 2007
