function w = MakeIterSineWindow(j,alpha)
% MakeIterSineWindow -- smooth window 
%  Usage
%    w = IteratedSineWindow(j,eps)
%  Inputs
%    j   window is located near a dyadic interval of length 2^j
%    alpha cut-off, alpha = (alpha^-, alpha^+), alpha^\pm = 0,1 
%  Outputs
%    w     rho(2^{\alpha^-} t) rho(2^{\alpha^+}(1 - t)) 
%                rho is the iterated sine cut-off function
%                1 if t > 1/2 and 0 if t < -1/2.
%
% See Also IteratedSine, MakeWindow
   
        step = 1/2^j;
	t = (-1/2):step:(3/2-step);
	
        w = IteratedSine(2^(alpha(1))*t).*IteratedSine(2^(alpha(2))*(1 - t));
	
	
	
	