function y = ThreshChirplet(x,sigma,thresh,D)
% ThreshChirplet -- Cosine packet decomposition of a noisy signal,
%		Best Basis analysis, Thresholding in Best Basis
%  Usage 
%    out=ThreshCP(Noisy,sigma,type,mult,D,bellname)
%  Inputs
%    x	        Noisy signal, signal must be of dyadic length 2^J
%    sigma  	Noise level 
%    lambda   	Multiplier of sigma to obtain the value of the threshold.
%           	Default is sqrt(2*log(n))
%    D          Maximum Depth (default is J-1)
%  Outputs 
%    y     	Reconstructed signal obtained by applying
%                               thresholding in best tight-frame.  


	[n,J] = dyadlength(x);

 	if nargin < 4,
      		D=J-1;
  	end
  	if nargin < 3,
      		thresh = 3*sqrt(2);
  	end
        
	ch = ChirpletAnalysis(x,D);
	
	% Calculate Entropies and Find best balanced tree
	
	lambda = 2*sigma^2*(2 * log(n));
        [cost,slope] = CostChirpletTree(ch,lambda);
        [basis,split,value] = BestBalancedTree(cost,D);
        value(1,1,1) = Inf;
	bestbasis = FindBasis(basis,split,value,'Yes');
	
	% Apply Thresholding and Reconstruct
	
	for s = 0:D,
	  for b = 0:(2^s-1),
	  ch{node(s,b)} = ch{node(s,b)} .* (abs(ch{node(s,b)}) >= ...
					    thresh*sigma);
	  end
	end
	 	 
	y = ChirpletSynthesis(bestbasis,slope,ch);
	
	
% Copyright (c) Emmanuel Candes and Hannes Helgason, California Institute of Technology, 2007
