% ACROSS Amplitude of cross-polarised component of GW wave (to first order).
%
%   [Ac, f] = Across(t, m1, m2, tc, w, D)
%
% Inputs:
%   t      - time (seconds)
%   m1, m2 - masses (solar masses)
%   tc     - time of coalescence (seconds)
%   w      - angle of inclination of source to Earth (radians)
%   D      - distance to source (metres)
%
% Outputs
%  Ac      - amplitude of h_\cross GW-component at t, the coefficient of
%            of sin(phi(t)).
%  f       - (optional) instantaneous frequency at t (Hz) (f = 2*pi*p')
function [Ac, f]=Across(t, m1, m2, tc, w, D)

  % Constants

  T0 = 4.925E-06;    % seconds
  c = 3.0E+08;       % speed of light (metres/second)

  % Derived quantities

  M = m1 + m2;       % total mass
  eta = m1*m2/(M^2); % symmetric mass ratio (unitless)

  f = F(t, m1, m2, tc);

  Ac = -2*T0*c/D*(2*cos(w))*(eta*M)*(pi*M*T0*f).^(2/3);

return;
