% F Instantaneous frequency of the gravitational wave as a function of t
%
%   f = F(t, m1, m2, tc)
%
% Inputs:
%   t      - time (seconds)
%   m1, m2 - masses (solar masses)
%   tc     - time from t = 0 to coalescence (at end t = tc)
%
% Outputs:
%   f      - instantaneous frequency at t
function f=F(t, m1, m2, tc)

  % Constants

  T0 = 4.925E-06;    % seconds

  % Derived values

  M = m1 + m2;       % total mass
  eta = m1*m2/(M^2); % symmetric mass ratio (unitless)

  % Coefficients of expansion

  a0 = 1.0;

  % Coeff of theta^1 is 0
  %a1 = 0.0;

  a2 = 743/2688 + 11/32*eta;

  % These terms can produce negative values of f (bad), so
  % they are turned off for now
  %a3 = -3*pi/10;
  a3 = 0.0;

  %a4 = 1855099/14450688 + 56975/258048*eta + 371/2048*eta^2;
  a4 = 0.0;

  theta = (eta*(tc - t)/(5*M*T0)).^(-1/8);

  f = theta.^3/(8*pi*M*T0).*(a0 + a2*theta.^2 + a3*theta.^3 + a4*theta.^4);

return;
