% Test for inspiral.m
%
% Neutron star binary inspiral (1.4-1.4 solar masses)

m1 = 1.4;          % mass of object 1
m2 = 1.4;          % mass of object 2
srate = 2048;      % sample rate (Hz)
tc = 32.0;         % time from t = 0 to coalescence (seconds)
w = 0.0;           % angle of inclination
f0 = 40.0;         % reference frequency (Hz)

dt = 1/srate;      % sample size (seconds)

N = floor(srate*tc);   % Number of data points needed
t = [0:N-1].'*dt;      % Time parameter

[h, p, f] = inspiral(t, m1, m2, tc, w, f0);

subplot(4, 1, 1);
plot(t, p);
axis tight
xlabel('Time (s)');
ylabel('\phi(t)');
title('Binary inspiral waveform');

subplot(4, 1, 2);
plot(t, f);
axis tight
xlabel('Time (s)');
ylabel('F(t) = 2\pi\phi\prime(t)');

subplot(4, 1, 3);
plot(t, h);
axis tight
xlabel('Time (s)');
ylabel('h(t)');

subplot(4, 1, 4);
Nfft = 512;
specgram(h, Nfft, srate, Nfft/2);
