% TV Function to calculate time as a function of velocity for inspiral
%
%   t=tv(v, m1, m2, tc)
%
function t=tv(v, m1, m2, tc)

  % Constants

  T0 = 4.925E-06;    % (seconds)

  % Derived values

  M = m1 + m2;       % total mass
  eta = m1*m2/(M^2); % symmetric mass ratio (unitless)

  % Coefficients of expansion

  a0 = 1.0;
  % Coeff of v^1 is 0 ie. a1 = 0.0;
  a2 = 743/252 + 11/3*eta;
  a3 = -32*pi/5;
  a4 = 3058673/508032 + 5429/504*eta + 617/72*eta^2;

  t = tc - 5*M*T0/(256*eta)*v.^(-8).*(a0 + a2*v.^2 + a3*v.^3 + a4*v.^4);

return;
