% V2T Function to calculate velocity-squared as a function of time
% for binary inspiral. The amplitude of the sinusoidal waveform is
% proportional to v^2
%
%  v2 = v2t(t, m1, m2, tc)
%
% Not used in main inspiral routine since it is rather slow. Instead
% we use a simple first-order approximation to the amplitude.
function v2=v2t(t, m1, m2, tc)

% Constants

T0 = 4.925E-06;    % (seconds)

% Derived values

M = m1 + m2;       % total mass
eta = m1*m2/(M^2); % symmetric mass ratio (unitless)

% Coefficients of expansion of t(v)

ct = (t - tc)*256*eta/(5*M*T0);
v2 = zeros(1, length(t));

c = zeros(1, 5);

c(5) = 1.0;
c(4) = 743/252 + 11/3*eta;

for k = 1:length(ct)
    c(1) = ct(k);
    r = roots(c);
    v2(k) = max(r);
end;

return;
