% VT Function to calculate velocity as a function of time
% for binary inspiral.
%
%  v = vt(t, m1, m2, tc)
%
function v=vt(t, m1, m2, tc)

% Constants

T0 = 4.925E-06;    % (seconds)

% Derived values

M = m1 + m2;       % total mass
eta = m1*m2/(M^2); % symmetric mass ratio (unitless)

% Coefficients of expansion of t(v)

ct = (t - tc)*256*eta/(5*M*T0);
v = zeros(1, length(t));

c = zeros(1, 9);

c(9) = 1.0;
c(7) = 743/252 + 11/3*eta;
c(6) = -32*pi/5;
c(5) = 3058673/508032 + 5429/504*eta + 617/72*eta^2;

for k = 1:length(ct)
    c(1) = ct(k);
    r = roots(c);
    v(k) = max(r);
end;

return;
