function [Q,R] = SetupStep2(t)
% A helper function for SplineSmoother.m
%
% t = [t_1,...,t_n]

n = length(t);
t = reshape(t,n,1);

h = diff(t);

% R: band entries
ind = 2:(n-1);
rii = 1/3 * (h(ind) + h(ind-1));
tmp = 1/6 * h(2:(n-2));
rabovediag = [0;tmp];
rbelowdiag = [tmp;0];
R = spdiags([rbelowdiag rii  rabovediag],[-1 0 1],n-2,n-2);

% Q: band entries
qbelowdiag = 1./h(2:(n-1));
qabovediag = 1./h(1:(n-2));
qdiag = -qbelowdiag - qabovediag;

Q = spdiags([qbelowdiag qdiag qabovediag],[-2 -1 0],n,n-2);

% $RCSfile: SetupStep2.m,v $
% $Date: 2008/05/19 20:05:12 $
% $Revision: 1.1 $
%
% Copyright (c) Hannes Helgason, California Institute of Technology, 2007
