function DisplayChirpletPath(chirpletpath,cgraphparam)
% DisplayChirpletPath -- Plots a chirplet path
%            
%  Usage
%    DisplayChirpletPath(chirpletpath,cgraphparam)
%  Inputs
%    chirpletpath   a chirplet path as returned by the function
%                   CalculateTestStatistic
%    cgraphparam    chirplet graph parameters as returned by
%                   GetChirpletGraphParam. Has to be the same set of
%                   parameters as used in CalculateTestStatistic.                  
%
%  See Also
%    - GetChirpletGraphParam
%    - CalculateStatistic
%    - Path2TF, DisplayChirplets

J = cgraphparam{1}(2);    % dyadic length of signal
fsc = cgraphparam{2}(2);  % finest scale in the chirplet graph 
fmin = cgraphparam{4}(1); % lowest frequency in the chirplet graph 
fmax = cgraphparam{4}(2); % highest frequency in the chirplet graph 
[t,f] = Path2TF(chirpletpath,J,fmin,fmax,fsc);    % get time-freq indices
DisplayChirplets(t,f,2^J); % plot

% $RCSfile: DisplayChirpletPath.m,v $
% $Date: 2006/05/01 17:52:55 $
% $Revision: 1.3 $
%
% Copyright (c) Hannes Helgason, California Institute of Technology, 2006
