function DisplayChirplets(t,freq,n)
% DisplayChirplets -- Plots a chirplet path given 
%                     time and frequency indices
%            
%  Usage
%    DisplayChirplets(t,freq,n)
%  Inputs
%    t       time coordinates for the chirplet path
%    freq    frequency indices for the chirplet path
%    n		 length of underlying signal
%
%  Description
%    This is a subroutine of DisplayChirpletPath so
%    it is better to use that function for plotting
%    chirplet paths. Otherwise, use Path2TF to get
%    the time and frequency coordinates for the chirplet
%    path and then use this function. 
%    
%  See Also
%    - DisplayChirpletPath, Path2TF
%    - CalculateStatistic

plot(0:n,zeros(1,n+1),'b');
axis([0 n -n/2 n/2]);
hold on;

nchirplets = length(t) - 1;

for k = 1:nchirplets,
  t0 = t(k); t1 = t(k+1);
  f0 = freq(k); f1 = freq(k+1);
  
  nblock = t1-t0;
  deep = log2(n/nblock);
 
  slope = FreqIndexToSlope(deep,[f0 f1],n);
  tt = [t0 t1];
  omega = f0 +  slope .* (tt - t0); 
  omega =  FreqIndexToOmega(omega,n);
  
  plot([t0 t0], [-n/2 n/2],'r--'); plot([t1 t1], [-n/2 n/2],'r--');
  plot(tt,omega,'LineWidth',6,'Color','r');
end

hold off;

% $RCSfile: DisplayChirplets.m,v $
% $Date: 2006/05/01 17:52:55 $
% $Revision: 1.7 $
%
% Copyright (c) Hannes Helgason, California Institute of Technology, 2006
