function omega = FreqIndexToOmega(k,n)
% FreqIndexToOmega --  returns maps frequencies to the range [-n/2,n/2]
%            
%  Usage
%    omega = FreqIndexToOmega(freqs,n)
%  Inputs
%    freqs   a vector of frequency indices
%    n		 length of underlying signal
%  Outputs
%    omega   the frequencies in freqs mapped in the range [-n/2,n/2]
%
%  Description
%    This is a subroutine of DisplayChirplets.
%    For plotting chirplet paths use DisplayChirpletPath.
%    
%  See Also
%    - DisplayChirpletPath, Path2TF
%    - CalculateStatistic

n2 = n/2;
omega = rem(k - 1 +n2,n) - n2;



% $RCSfile: FreqIndexToOmega.m,v $
% $Date: 2006/05/01 17:52:55 $
% $Revision: 1.3 $
%
% Copyright (c) Hannes Helgason, California Institute of Technology, 2006
