% MakeRealNoise -- Generates a sample of real stationary Gaussian noise
% with the spectrum S
% Usage
%   x = MakeRealNoise(S)
% Inputs
%   S      2-sided power spectrum of noise in FFT order
% Output
%   x      a sample of coloured Gaussian noise with the same length as S
function x = MakeRealNoise(S)

  if (min(size(S)) ~= 1)
    error('Spectrum must be a vector');
  end;

  sqrtS = sqrt(S);

  w = randn(size(sqrtS));
  x = real(ifft(sqrtS.*fft(w)));

return;

% $RCSfile: MakeRealNoise.m,v $
% $Date: 2007/02/04 02:34:49 $
% $Revision: 1.4 $
%
% Copyright (c) Philip Charlton, California Institute of Technology, 2006
