function [t,freq] = Path2TF(p,J,fmin,fmax,fsc)
% Path2TF -- Returns the time and frequency indices
%            for the given chirplet path p as returned by
%            CalculateStatistic, minctratiocells or ShortestPathCell.
%  Usage
%    [t,f] = Path2TF(p,J)
%    [t,f] = Path2TF(p,J,fmin)
%    [t,f] = Path2TF(p,J,fmin,fmax)
%  Inputs
%    p		array of the topological order of the nodes along a path
%    J       dyadic length of signal
%    fmin    minimum frequency allowed, default 0
%    fmax    maximum frequency allowed, default 2^J-1
%    fsc     the finest scale in the chirplet gragh, default J-1
%  Outputs
%    t       time-coordinates for the chirplet path
%    freq    frequency indices for the chirplet path
%
%  See Also
%    - DisplayChirplets, DisplayChirpletPath
%    - CalculateStatistic

if (nargin < 5),
    fsc = J-1;
    if (nargin < 4),
        fmax = 2^J-1;
        if (nargin < 3),
            fmin = 0;
        end
    end
end

nfreqs = fmax-fmin+1; % number of frequency indices per time
f = mod(p-1,nfreqs); 
t = (p - f - 1)/(nfreqs/2^(J-fsc)); % PEND! Needs to be changed for finest scale
freq = f+fmin+1;  % +1 because we index the frequencies from 1 to N
             % where N=2^J is the length of the signal



% $RCSfile: Path2TF.m,v $
% $Date: 2006/05/01 17:52:56 $
% $Revision: 1.5 $
%
% Copyright (c) Hannes Helgason, California Institute of Technology, 2006
