/** 
 *  CSPcell_mex.cpp
 *  Used to solve the constrained shortest path problem for an acyclic graph
 *  and unit timelengths per axis, starting from given
 *  start nodes to given endnodes. Uses a cell array data structure for the 
 *  network. 
 */

#include "mex.h"
#include <vector>
using namespace std;

/* 
#include <cmath>
   Gateway function 

   Inputs:
	prhs[0] - a cell array where cell k is a vector corresponding to node k in the 
		graph and holds all the nodes that node k connects to.
	prhs[1] - a cell array with the costs corresponding to the arcs described in prhs[0].
     	prhs[2] - total number of nodes in graph.
	prhs[3] - a constant to update the costs on the arcs, the updated cost will be the
		old cost as described in prhs[1] minus alpha. (Needed to find the MCTR)
	prhs[4] - a vector with the topological ordering of the nodes in G
	prhs[5] - list of nodes from where paths can start in the acyclic network.

   Outputs:
	plhs[0] - a vector with the distance labels for all the nodes in the graph
	plhs[1] - list of predecessor nodes for the shortest path
*/
void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray
                 *prhs[]) 
{ 
  double *arcs;         // the set of endpoints and costs of arcs 
                        // emanating out of node k
  int nArcs;            // number of arcs
  double *arcCosts;     // the arc costs
  double *startNodes;   // starting nodes in the graph
  double *endNodes;     // end nodes in the graph
  int nStartNodes;      // length of the array start nodes
  int nEndNodes;        // length of the array end nodes 
  int nNodes;           // number of nodes in graph
  int maxLength;
 
  const mxArray *cellElementPtr;
  int startNode;
  int arcIndex;
  double tentativeDistance;
  int k;
  int l;
  
//  vector< vector<int> > pred;  // predecessor nodes
  vector< vector<double> > d;    // distance labels

  double *costs;          // optimal costs for different lengths
  
  /* Get input data */
  nNodes = (int) mxGetScalar(prhs[2]);
  startNodes = mxGetPr(prhs[3]);
  nStartNodes = mxGetNumberOfElements(prhs[3]);
  endNodes = mxGetPr(prhs[4]);
  nEndNodes = mxGetNumberOfElements(prhs[4]);
  maxLength = (int) mxGetScalar(prhs[5]); 
  int nLeftEndpoints;   // number of nodes that arcs emanate from  
  nLeftEndpoints = (int) mxGetScalar(prhs[6]);
    
  // initialize the size of d and pred
  d.resize(nNodes);
//  pred.resize(nNodes);
   
  // Initialize d
  // starting nodes have the distance label 0
  for (k=0; k < nStartNodes; k++) {
//    for (l=0; l<maxLength+1; l++) { // +1 to take care of zero length
      d[k].push_back(0);
//    }
  }

  //  set all other distance labels to infinity
  for (k=nStartNodes; k < nNodes; k++) {
 //   for (l=0; l<maxLength+1; l++) { // +1 to take care of zero length
      d[k].push_back(mxGetInf());
 //   }
  }


  // Examine nodes in topological order
  for (startNode=0; startNode < nLeftEndpoints; startNode++) {
    cellElementPtr = mxGetCell(prhs[0], startNode);
    // the cell could be empty, so in that case we do nothing
    if (cellElementPtr == NULL) {
      continue;
    }
    // we reach this statement if the cell is not empty
    arcs = mxGetPr(cellElementPtr);
    // arcs is the set of endpoints of arcs emanating from startNode
    nArcs = mxGetNumberOfElements(cellElementPtr);
    
    cellElementPtr = mxGetCell(prhs[1], startNode);
    arcCosts = mxGetPr(cellElementPtr);

    for (k=0; k < nArcs; k++) {
//      for (l=1; l<maxLength+1; l++) { // +1 to take care of zero length
      arcIndex = (int) arcs[k] - 1;
      for (l=1; l < d[startNode].size()+1 ; l++) {
        tentativeDistance = d[startNode][l-1]+ arcCosts[k];
        if (d[arcIndex].size() < l+1) {
          // want to have the distance labels with dynamic size
          // since the maximum possible length of paths do a node
          // varies from node to node.
          d[arcIndex].push_back(tentativeDistance);          
        } else {
          if( d[arcIndex][l] > tentativeDistance ) {
            d[arcIndex][l] = tentativeDistance;
//            pred[arcIndex][l] = startNode;  // change predecessor node
          }
        }
      }
 
    }
    // This distance label is useless now, deleting it to free
    // up memory.
    d[startNode].clear();
  }
  

  // All distance labels are optimal. Just need to
  // read off the shortest distances for each length
  
  plhs[0] = mxCreateDoubleMatrix(1,maxLength,mxREAL);
  costs = mxGetPr(plhs[0]);
  
  for (l=0; l<maxLength; l++) {
    costs[l] = 0; // initialize
    for (k=0; k < nEndNodes; k++) {
      if ( d[(int) endNodes[k] - 1][l+1] < costs[l] ) { // +1 because first entry corresponds to zero length
        costs[l] =  d[(int) endNodes[k] - 1][l+1];
      }
    }
  }
  
}
