% ChirpPath:

global CHIRPLABPATH
global PATHNAMESEPARATOR
global PREFERIMAGEGRAPHICS
global MATLABPATHSEPARATOR
		
PREFERIMAGEGRAPHICS = 1;
Friend = computer;

if strcmp(Friend,'MAC2'),
  PATHNAMESEPARATOR = ':';
  CHIRPLABPATH = [pwd, PATHNAMESEPARATOR];
  MATLABPATHSEPARATOR = ';';
elseif isunix,
  % Mac OS X returns isunix=1
  PATHNAMESEPARATOR = '/';
  CHIRPLABPATH = [pwd, PATHNAMESEPARATOR];
  MATLABPATHSEPARATOR = ':';
elseif strcmp(Friend(1:2),'PC');
  PATHNAMESEPARATOR = '\';	  
  CHIRPLABPATH = [pwd, PATHNAMESEPARATOR];  
  MATLABPATHSEPARATOR = ';';
end

disp('-- STARTING CHIRPLAB --')
disp('Adding ChirpLab to MATLAB path...')

post = PATHNAMESEPARATOR;
p = path;
pref = [MATLABPATHSEPARATOR CHIRPLABPATH];
p = [p pref];

% mex code (has to come first in the search path)
p = [p pref 'mex' post 'src' post 'Networks' post];
p = [p pref 'mex' post 'src' post 'ChirpletTrans' post];

% m-code
p = [p pref 'ChirpletTrans' post];
p = [p pref 'Networks' post ];
p = [p pref 'BPEstimator' post ];
p = [p pref 'SplineSmoothing' post ];
p = [p pref 'Estimation' post ];

% data folder
p = [p pref 'Data' post];
p = [p pref 'Data' post 'ForDemos' post];

p = [p pref 'Demos' post];
p = [p pref 'Utilities' post];

% Inspiral code
p = [p pref 'Inspiral' post];




path(p);


% Check if MEX files have been compiled and compile them if needed
CompileMex;

clear p pref post
clear CHIRPLABPATH MATLABVERSION PATHNAMESEPARATOR
clear Friend PREFERIMAGEGRAPHICS MATLABPATHSEPARATOR

% $RCSfile: ChirpPath.m,v $
% $Date: 2008/05/20 14:09:41 $
% $Revision: 1.13 $
%
% Copyright (c) Hannes Helgason, California Institute of Technology, 2006
