function A = PolynomialsInt(N,maxDegree)
% PolynomialsInt -- generates orthogonal polynomials on an interval
%
%  Usage
%    A = PolynomialsInt(N,maxDegree)
%  Input
%    N          The number of evenly spaced points.
%    maxDegree  choose the maximum polynomial degree either 0, 1 or 2.
%  Outputs
%    A       a (maxDegree+1)-by-N matrix with the value of the polynomials.
%            Row k corresponds to a polynomial of degree k-1.
%
%  Description
%    Returns up to three orthogonal polynomials of degrees 0, 1 to 2 
%    at N evenly spaced points from 0 to 1-1/N. Each polynomial has norm 1.
%    This is used by the varying amplitude adjusted chirplet transform.
%
%  See Also
%    - GetChirpletGraphParam
%    - ChirpletTransform

t0 = 0;
t1 = 1-1/N;
t = t0:1/N:t1;

p0 = ones(1,N)/sqrt(N);

if (maxDegree > 0),
  a1 = (t.*p0)*p0';
  p1 = (t-a1);
  p1 = p1/norm(p1);
  a1 = (t.*p1)*p1';
  b1 = (t.*p1)*p0';
  if (maxDegree==2),
    p2 = (t-a1).*p1 - b1*p0;
    p2 = p2/norm(p2);

    A = [p0;p1;p2];
  else
    A = [p0;p1];
  end
else
  A = p0;
end
% $RCSfile: PolynomialsInt.m,v $
% $Date: 2006/05/01 17:44:15 $
% $Revision: 1.5 $
%
% Copyright (c) Hannes Helgason, California Institute of Technology, 2006
