% A sample script to run SplineSmoother.m

n = 1000;
t = linspace(0,1,n)';

p = 16*(t-0.5).^3;
noise = randn(n,1);
y = p + noise;

figure(1);
plot(t,p,'--',t,y);

alpha = 0.001:0.001:0.05;
tic;
[yhat,CV] = SplineSmoother(y,t,alpha);
toc

figure(2);
plot(t,p,'--',t,yhat);


% $RCSfile: SplineSmootherDemo.m,v $
% $Date: 2008/05/19 20:15:32 $
% $Revision: 1.1 $
%
% Copyright (c) Hannes Helgason, California Institute of Technology, 2007
