function [d,b,endpoints] = BRDPindex(basis)

itree = 1:length(basis);
ntree = itree(basis == 0);

d = floor(log2(ntree));
b = ntree - 2.^d;
t = b .* 2.^(-d);
[t,I] = sort(t);
d = d(I); b = b(I);

nintervals = length(ntree);
endpoints = zeros(2,nintervals);
for k = 1:nintervals,
  if (k == nintervals) 
    nextk = 1;
  else
    nextk = k+1;
  end
  
  if (d(nextk) == d(k))
    endpoints(2,k) = 1;
    endpoints(1,nextk) = 1; 
  elseif (d(nextk) == d(k)+1)
    endpoints(2,k) = 2;
    endpoints(1,nextk) = 1; 
  elseif (d(nextk) == d(k)-1)
    endpoints(2,k) = 1;
    endpoints(1,nextk) = 2; 
  else 
    fprintf('This is not a balanced recursive dyadic partititon\n')
  end  
end

% Copyright (c) Emmanuel Candes and Hannes Helgason, California Institute of Technology, 2007
