function x = ChirpletSynthesis(basis,slope,ch)
% ChirpletSynthesis -- Synthesize signal from chirplet coefficient table
%  Usage
%    x = CPSynthesis(btree,cp)
%  Inputs
%    basis    basis tree indicating basis to work in
%    ch       Chirplet coefficient table
%  Outputs
%    x        signal whose coefficients in basis btree come from ch

	n = size(ch{node(0,0)},1); 
	L = log2(length(ch) + 1); D = L -1;
	
	x = zeros(1,n);

        [scale,location,endpoints] = BRDPindex(basis);
	nintervals = length(scale);
	
	for k = 1:nintervals;
	  d = scale(k); b = location(k);
	  alpha = endpoints(1,k); beta = endpoints(2,k); 
	  nd = n/2^d; nd2 = nd/2; jd = log2(nd);
	  
	  all_slopes = (0:(nd-1))/nd - 1/2;	  
	  bslope_index = slope(alpha,beta,node(d,b)); 
	  bslope = all_slopes(bslope_index);
	  cc = ch{node(d,b)}(:,bslope_index);
           	  
	  t =  -nd2:(3*nd2-1);
	  xc = ifft(cc).*sqrt(2*nd);
	  xc = xc.' .* exp(i*pi*bslope*t.^2/n);
	  
	  low = b*nd + 1 - nd2; hi = (b+1)*nd + nd2;
	  index = low:hi;
	  if (b == 0 || b == 2^d -1)
	    index = CircularWrap(low:hi,n);
	  end
	 
	  w = MakeIterSineWindow(jd,[(alpha-1) (beta -1)]);
	  x(index) = x(index) + xc.*w;
	end
	
% Copyright (c) Emmanuel Candes and Hannes Helgason, California Institute of Technology, 2007
