% Test for inspiral with more accurate amplitude modeling

% Neutron star binary inspiral (1.4-1.4 solar masses)
m1 = 1.4;          % mass of object 1 (solar masses)
m2 = 1.4;          % mass of object 2 (solar masses)
tc = 32.0;         % time to coalescence (seconds)
srate = 2048;      % sample rate (Hz)
dt = 1/srate;
N = tc*srate;

t = [0:N-1]*dt;

% Calculate the phase as a function of time
ph = phi(t, m1, m2, tc);

% Calculate the inst. frequency
f = F(t, m1, m2, tc);

% Calculate the GW amplitude as a function of time (velocity squared)
v2 = v2t(t, m1, m2, tc);

h = v2.*cos(ph);

subplot(4, 1, 1);
plot(t, ph);
axis tight
xlabel('time (s)');
ylabel('\phi(t)');

subplot(4, 1, 2);
plot(t, f);
axis tight;
xlabel('time (s)');
ylabel('F(t) = \phi\prime(t)');

subplot(4, 1, 3);
plot(t, h);
axis tight;
xlabel('time (s)');
ylabel('h(t)');

subplot(4, 1, 4);
Nfft = 512;
specgram(h, Nfft, srate, Nfft/2);
