% PHI Phase of the gravitational wave as function of t
%
%   p = phi(t, m1, m2, tc)
%
% Inputs:
%   t      - time (seconds)
%   m1, m2 - masses (solar masses)
%   tc     - time from t = 0 to coalescence (at end t = tc)
%
% Outputs:
%   p      - phase at t
function p=phi(t, m1, m2, tc)

  % Constants

  T0 = 4.925E-06;    % (seconds)

  % Derived values

  M = m1 + m2;       % total mass
  eta = m1*m2/(M^2); % symmetric mass ratio (unitless)

  % Coefficients of expansion

  a0 = 1.0;
  % Coeff of theta^1 is 0 ie. a1 = 0.0;
  a2 = 3715/8064 + 55/96*eta;

  % Only going to 1-PN
  %a3 = -3*pi/4;
  a3 = 0;
  %a4 = 9275495/14450688 + 284875/258048*eta + 1855/2048*eta^2;
  a4 = 0;

  theta = (eta*(tc - t)/(5*M*T0)).^(-1/8);

  p = -2.0/eta*theta.^(-5).*(a0 + a2*theta.^2 + a3*theta.^3 + a4*theta.^4);

return;
