function cost = CSPstatistic(G,n,startnodes,endnodes,maxLength)
% CSPstatistic  -- solves the shortest path problem for an acyclic graph with
%                  a constraint on the maximum number of arcs that the path can have. 
%                  Does not return the best paths, only the costs. 
%                  
%  Usage
%    cost = CSPstatistic(G,n,alpha,order,startnodes,endnodes,L)
%  Inputs
%    G          a cell array of size (k,2) where k is the number of nodes in the graph
%               for which arcs go out from. cell (m,1) is a vector with all the nodes 
%               that node m connects to and cell (m,2) is a vector with the corresponding
%               arc costs
%    n          total number of nodes in graph.
%    startnodes	list of nodes from where paths can start in the acyclic network.
%    endnodes	list of nodes from where paths can end in the acyclic network.
%    L		    Maximum number of arcs that the best path is allowed to have.
%  Outputs
%    cost	    The cost of the shortest path.
%
%  Description
%    This is an inner function in ChirpLab.
%    It is recommended to use CalculateStatistic instead.
%
%  See Also:
%    - CalculateStatistic
%    - CSPcell

nG = size(G,1);  % returns the number of starting nodes in G
if nargin < 4
  % Topological order was not provided. Assume that the
  % nodes in G appear in topological order.
  ord = 1:nG;
end

% Call mex function to find the distance labels and the list of
% predecessor nodes for the shortest path.
%[d,pred] = CSPcell_mex(G(:,1),G(:,2),n,startnodes,endnodes,maxLength,nG);
cost = CSPcell_mex(G(:,1),G(:,2),n,startnodes,endnodes,maxLength,nG);

% Now we figure out which of the endnodes has the lowest distance label. That is going to be
% the end node of our shortest path. To find the shortest path we just have to start at
% the endnode and track the predecessor nodes.
%[cost,ind] = min(d(endnodes));
%path = pred2sp( pred(1:endnodes(ind)) );

% Now we figure out which of the endnodes has the lowest distance label. That is going to be
% the end node of our shortest path. To find the shortest path we just have to start at
% the endnode and track the predecessor nodes.
%cost = zeros(1,maxLength+1);
%ind = zeros(1,maxLength+1);

%for m = 1:(maxLength+1),
%  [cost(m),ind(m)] = min(d(m,endnodes));
%end

%cost = cost(2:(maxLength+1));

%if (nargout > 1),
  % the caller wanted to get the paths, so find them 
%  paths = cell(1,maxLength)
%  for k=1:maxLength,
%    paths{k} = zeros(1,k+1);
%    paths{k}(k+1) = endnodes(ind(k+1));
%    for l=k:-1:1,
%      paths{k}(l) = pred(l+1,paths{k}(l+1));
%    end
%  end
%end


% $RCSfile: CSPstatistic.m,v $
% $Date: 2006/10/11 22:57:51 $
% $Revision: 1.4 $
%
% Copyright (c) Hannes Helgason, California Institute of Technology, 2006
