function thepath = pred2sp(pred)  
% pred2sp -- extracts the shortest path from a vector of predecessor indices 
%
% Usage
%    path = pred2sp(pred) 
% Inputs 
%    pred 	pred(j) is the predecessor node of j in the shortest path (i.e. (pred(j),j) 
%           is an arc in the shortest path).
% Outputs
%   thepath	the list of nodes for the shortest path
%
% Description
%    Extracts the shortest path from a vector of predecessor indices.

n = length(pred);
thepath = [];

while (n~=0),
  thepath = [n thepath];
  n = pred(n); 
end

% $RCSfile: pred2sp.m,v $
% $Date: 2006/05/01 17:48:32 $
% $Revision: 1.3 $
%
% Copyright (c) Hannes Helgason, California Institute of Technology, 2004
