function slope = FreqIndexToSlope(deep,k,n)
% FreqIndexToSlopes --  returns chirplet slope from a given 
%                       scale and frequencies
%            
%  Usage
%    slope = FreqIndexToSlope(deep,freqs,n)
%  Inputs
%    deep    scale index corresponding to the scale 2^(-deep)
%    freqs   a vector of the form freqs=[f0 f1] where f0 and f1
%            are the start and end frequency, resp.
%    n		 length of underlying signal
%  Outputs
%    slope   the chirplet slope
%
%  Description
%    This is a subroutine of DisplayChirplets.
%    For plotting chirplet paths use DisplayChirpletPath.
%    
%  See Also
%    - DisplayChirpletPath, Path2TF
%    - CalculateStatistic

n2 = n/2;
nblock = n./2.^deep;
omega = mod(k-1,n);

slope = (omega(:,2) - omega(:,1))./nblock;
slope = slope + 2.^deep .* (slope < -2.^(deep-1)) - 2.^deep .* (slope ...
                                                  > 2.^(deep-1));  

% $RCSfile: FreqIndexToSlope.m,v $
% $Date: 2006/05/01 17:52:55 $
% $Revision: 1.3 $
%
% Copyright (c) Hannes Helgason, California Institute of Technology, 2006
