function thresh = GetThreshold(data,alpha,rejectForBig)
% GetThreshold -- estimate the threshold for a given significance level from
%                 realizations of a random variable
%
%  Usage
%    thresh = GetThreshold(T,alpha,rejectForBig)
%  Inputs
%    data           data vector with realizations of a random variable X
%    alpha          a vector of significance levels (type I errors) for
%                   which the thresholds should be retrieved from.
%                   The distribution of X is estimated from the parameter data
%                   using the function ECDF in MATLAB.
%    rejectForBig   if set to 1, alpha = P(X>thresh) (approximately)
%                   if set to 0, alpha = P(X<thresh) (approximately)
%                   If omitted, the default value is 1.
%  Outputs
%    thresh         a vector of threshold values that give the approximately
%                   the significance levels in the vector alpha.

if (nargin < 3),
  rejectForBig = 1;
end

[f,x] = ecdf(data);
for k=1:length(alpha),
  if (rejectForBig==1),
    ind = find(f <= 1-alpha(k),1,'last');
  elseif (rejectForBig==0),
    ind = find(f >= alpha(k),1,'first');
  else
    errormsg = 'GetThreshold: the parameter rejectForBig has to be set to 0 or 1';
    error(errormsg);
  end
  thresh(k) = x(ind);
end

% $RCSfile: GetThreshold.m,v $
% $Date: 2006/05/01 17:52:55 $
% $Revision: 1.2 $
%
% Copyright (c) Hannes Helgason, California Institute of Technology, 2006
