% MAKEREALNOISE2 Generates a sample of real stationary Gaussian noise
% with the power spectrum P
%
% Usage
%   x = noise(P)
%
% Inputs
%   P      2-sided power spectrum of noise in FFT order
%
% Output
%   x      a sample of Gaussian noise with the same length as P
function x = MakeRealNoise2(P)

  if (min(size(P)) ~= 1)
    error('Spectrum must be a vector');
  end;

  N = length(P);
  sqrtP = sqrt(P);

  % Generate the real and imaginary components of the DFT
  % of Gaussian noise (use a real number for the Nyquist)
  dc = randn(1, 1);       % DC
  a = randn(1, N/2 - 1);
  b = randn(1, N/2 - 1);
  c = randn(1, 1);        % Nyquist
  x = sqrtP(1:N/2+1).*[ dc, (a + i*b)/sqrt(2), c ];
  x = [ x, conj(x(end-1:-1:2)) ];
  x = sqrt(N)*real(ifft(x));

return;

% $RCSfile: MakeRealNoise2.m,v $
% $Date: 2007/02/06 20:21:24 $
% $Revision: 1.5 $
%
% Copyright (c) Philip Charlton, California Institute of Technology, 2006
