% SPW_INNER Spectrally-weighted inner product
%
% Usage:
%   inn = spw_inner(u, v);
%
% Spectrally-weighted inner product <u, v> with LIGO conventions
% S must be in units strain^2, FFT ordered.
function x=spw_inner(u, v, S)

  N = length(S);
  x = (1/N)*sum( fft(u, N).*conj(fft(v, N))./S );

  if (isreal(u) & isreal(v))
    x = real(x);
  end;
  
return;

