function ShowTaggedIntervals(taggedInt,minScale,maxScale)
% ShowTaggedIntervals -- Draws a figure showing the promising dyadic intervals
%  Interval indexed by (s,k) will be drawn as the line segment [k*2^s (k+1)*2^s].
%                       
%  Usage
%    ShowTaggedIntervals(T,minScale,maxScale)
%  Input
%    taggedInt  list of intervals tagged as promising as returned by TaggedIntervals
%    minScale	dyadic length of shortest interval considered
%    maxScale   dyadic length of longest interval considered

nScales = maxScale-minScale+1;

figure;
hold on;
for m=1:nScales,
  s = minScale+m-1;
  nIntervals = length(taggedInt{m});
  for n=1:nIntervals,
    k = taggedInt{m}(n);
    % dyadic interval is indexed by (s,k)
    lPt = k*2^s+1;
    rPt = lPt+2^s;
    plot([lPt rPt],[s s],'-o');
  end
end
axis([xlim minScale-1 maxScale+1])
set(gca,'YTick',minScale:maxScale)
xlabel('index');ylabel('dyadic length of interval');
title('Promising intervals');
hold off;

% $RCSfile: ShowTaggedIntervals.m,v $
% $Date: 2007/05/19 20:16:10 $
% $Revision: 1.2 $
%
% Copyright (c) Hannes Helgason, California Institute of Technology, 2007
