function taggedInt = TagIntervals2(T,minScale,maxScale,numTagged)
% TagIntervals2 -- Tags promising dyadic intervals based on ordering
%                  the values of statistics
%  Usage
%    taggedInt = TagIntervals2(T,minScale,maxScale,numTagged)
%  Input
%    T		statistics as returned by MonoScaleBP
%    minScale	dyadic length of shortest interval to consider
%    maxScale   dyadic length of longest interval to consider
%               of statistic resulting in a p-value smaller
%               then pthresh are tagged as promising
%    numTagged  numTagged(k) is the number of intervals at scale
%               2^(k+minScale-1) to be tagged.
%               The intervals corresponding to the numTagged(k) 
%               biggest intervals are tagged as promising
%  Output
%    taggedInt  list of intervals tagged as promising

nScales = maxScale-minScale+1;
taggedInt = cell(1,nScales);

for k=1:nScales,
  [val, ind] = sort(T{k},2,'descend');
  taggedInt{k} = ind(1:numTagged(k))-1; % -1 since indexing starts at 0
end

% $RCSfile: TagIntervals2.m,v $
% $Date: 2007/05/19 20:10:14 $
% $Revision: 1.1 $
%
% Copyright (c) Hannes Helgason, California Institute of Technology, 2007
