/**
 * Base2Utilities.hpp -- Utility functions for working with powers of 2 
 *
 * THIS IS PART OF CHIRPLAB
 */
             
/**
 * $RCSfile: Base2Utilities.hpp,v $
 * $Date: 2007/05/17 04:14:21 $
 * $Revision: 1.1.1.1 $
 * Copyright (c) Hannes Helgason, California Institute of Technology, 2006
 */

#ifndef _BASE2UTILITIES_HPP_
#define _BASE2UTILITIES_HPP_

#include <cassert>

inline int pow2(int l);
inline int divPow2(unsigned x, int l);
inline int maxPower2(unsigned x);
inline int mod2(unsigned x, int k);

// IMPLEMENTATIONS
inline int pow2(int l) 
{ 
  assert(l>=0); 
  return (1<<l); 
}

// divides the integer x by 2^l
// NOTE: x has to be divisible by 2^l
inline int divPow2(unsigned x, int l) 
{ 
  assert(l>=0); 
  return (x>>l); 
}

//   Given an integer x, finds the maximum power of two that
//   it is divisible with.
inline int maxPower2(unsigned x)
{
  int b;
  for (b = 0; x!=0; x>>=1) {
    if (x & 01)
      break;
    else
      b++;
  }
  return b;
}

// Returns x mod(2^k) (an integer between 0 and 2^k-1).
// Inputs:
//	k	integer, must be positive
//	x	integer to calculate the modules for
// Output:
//	x mod(2^k)
inline int mod2(unsigned x, int k)
{
  // ~0 is all 1-bits
  // shifting it left k bit positions with ~0<<k places
  // zeros in the righmost k bits; complementing that with
  // ~ makes a mask with ones in the rightmost k bits
  return (x & ~(~0 << k));
}

#endif
