function [TT, intervalExtensions] = ExtIntAndFindBP(yy,overwhitened,P,lmax,smin,smax,...
                                       taggedIntervals,graphParamExtInt,CnormExtInt,maxLength)
% ExtIntAndFindBP -- extends the intervals tagged in stage I and calculates the BP statistic
%                    on each of them
%  Usage
%    [TT, intervalExtensions] = ExtIntAndFindBP(yy,overwhitened,P,lmax,smin,smax,...
%                                       taggedIntervals,graphParamExtInt,CnormExtInt,maxLength)
%  Input
%    yy      data stream to process. This is the same data stream processed in stage I.
%            It is possible to enter the "overwhitened"
%            data stream, i.e. the vector inv(Sigma)*y, where
%            Sigma is the covariance of the noise
%    overwhitened  set to 1 if the data stream in sig has been overwhitened
%            if omitted, the noise in sig is assumed to be colored
%            with noise spectrum P
%    P       The spectrum of the noise process
%    lmax    maximum extension level
%    smin    smallest scale of base intervals from stage I
%    smax    largest scale of base intervals from stage I
%    taggedIntervals
%    graphParamExtInt   a cell structure of of chirplet graph parameters as 
%            returned by InitGraphParam
%    CnormExtInt   chirplet normalization constants as returned by InitGraphParam
%    maxLength    maximum number of chirplets to use in the BP algorithm, vector
%            of the same form as returned by InitGraphParam
%  Output
%    TT           value of the BP statistic for 1 up to maxLength chirplets
%            for each extended interval 
%    intervalExtensions   list of the extended intervals, as returned
%            by ExtendIntervals


% Extend promising intervals
intervalExtensions = ExtendIntervals(length(yy),taggedIntervals,smin,smax,lmax);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Step II: Find BP for each interval extension
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
TT = cell(1,smax-smin+1);
for s=smin:smax,
  sindex = s-smin+1;
  [bogus, nExtensions] = size(intervalExtensions{s-smin+1});

  TT{sindex} = cell(1,nExtensions);
  for k=1:nExtensions,
    leftIndices = intervalExtensions{s-smin+1}{1,k};
    rightIndices = intervalExtensions{s-smin+1}{2,k};
    nLeftIndices = length(leftIndices);
    minLeftIndex = leftIndices(end);
    maxRightIndex = rightIndices(end);

    TT{sindex}{k} = cell(1,nLeftIndices);
    for li=1:nLeftIndices,
      % do chirplet transform
      ix = leftIndices(li):maxRightIndex;
      C2 = CTDataStream(yy(ix),graphParamExtInt{sindex},P,CnormExtInt{sindex},overwhitened); % yy has been overwhitened
      intLengths = rightIndices-leftIndices(li)+1;
      TT{sindex}{k}{li} = BPDirectDataStream(C2,graphParamExtInt{sindex},maxLength(sindex),intLengths);
    end
  end
end

% $RCSfile: ExtIntAndFindBP.m,v $
% $Date: 2008/05/25 16:53:41 $
% $Revision: 1.3 $
%
% Copyright (c) Hannes Helgason, California Institute of Technology, 2007
