function taggedInt = TagIntervals(T,minScale,maxScale,pthresh,fname)
% TagIntervals -- Tags promising dyadic intervals
%  Usage
%    taggedInt = TagIntervals(T,minScale,maxScale,pthresh,fname)
%  Input
%    T		statistics as returned by MonoScaleBP
%    minScale	dyadic length of shortest interval to consider
%    maxScale   dyadic length of longest interval to consider
%    pthresh    threshold for p-value; all intervals with value
%               of statistic resulting in a p-value smaller
%               then pthresh are tagged as promising
%    fname	file name where null distribution for calculating
%               p-values is stored
%  Output
%    taggedInt  list of intervals tagged as promising

nScales = maxScale-minScale+1;
taggedInt = cell(1,nScales);

% Find p-values 

%load LIGONOISEnullDists;
load(fname)
[nLeftEndpoints,nIntLengths] = size(T);

pvals = cell(1,nIntLengths);
for k=1:nIntLengths,
  % The ECDF
  X = ecdfs{2,k+minScale-smin};
  F = ecdfs{1,k+minScale-smin};
  vals = T{k};
  pvalsTmp = zeros(nLeftEndpoints, 1);
  pvalsTmp = interp1(X, 1-F, vals, 'linear', 0);

  outside = (vals < X(1));
  pvalsTmp(outside) = 1;
  pvals{k} = pvalsTmp;
end


% sort all p-values
allPvals = [];
nPvalsScale = zeros(1,nScales);
for k=1:nScales,
  nPvalsScale(k) = length(pvals{k});
  allPvals = [allPvals pvals{k}];
end
[tmp,tmpInd] = sort(allPvals);

% tag intervals with p-values less than pthresh
indLessSomePercent = tmpInd(tmp<=pthresh);

lb = [0 cumsum(nPvalsScale)];
ub = [cumsum(nPvalsScale) Inf];
correction = 0;
for k=1:nScales,
  taggedInt{k} = indLessSomePercent(...
                    indLessSomePercent > lb(k) &...
                    indLessSomePercent<=ub(k)) - lb(k) -1; % -1 since we want the dyadic index counting from 0
end


% $RCSfile: TagIntervals.m,v $
% $Date: 2007/05/19 20:16:10 $
% $Revision: 1.2 $
%
% Copyright (c) Hannes Helgason, California Institute of Technology, 2007
