#!/bin/csh -f

setenv MKL_NUM_THREADS 1

if( $#argv < 2 ) then
	echo "batch.bat header temperatures"
	exit
endif

set PRG = ~/pgm/amplitude.x

set FILE = $1
set TV   = $2
#set TR   = $3

if( $#argv > 2 ) then
   set MODES = $3
else
   set MODES = ( internal shrunk shrink jump walk )
endif

if(-e ../input/{$FILE}.dat) then
	set DATA = {$FILE}.dat
else if(-e ../input/{$FILE}.fchk) then
	set DATA = {$FILE}.fchk
else if(-e ../input/{$FILE}.out) then
	set DATA = {$FILE}.out
endif

set ZMT  = {$FILE}.zmt

foreach mode ( $MODES )

 ( $PRG ../input/$DATA Tv={$TV} zmt={../input/$ZMT} task={$mode} \
   >  {$FILE}.{$mode}.{$TV}.amp ) \
   >& {$FILE}.{$mode}.{$TV}.log


# ( $PRG $DATA Tv={$TV} Tr={$TR} zmt={$ZMT} task={$mode} \
#   >  {$FILE}.amp.{$mode}.{$TV}.{$TR} ) \
#   >& {$FILE}.log.{$mode}.{$TV}.{$TR}

end

