#!/bin/sh

export MKL_NUM_THREADS=2

if [ $# -lt 3 ]; then
	echo "batch.bat header temperatures"
	exit
fi

PRG="/home/stpark/source/amplitudes/past/source/amplitude.x"

FILE=$1
TV=$2
TR=$3
ZMT=$FILE.zmt

if [ $# -gt 3 ]; then
	MODES=$4
else
	MODES=( shrunk jump walk run )
fi

[ -e $FILE.fchk ] && export DATA=${FILE}.fchk
[ -e $FILE.dat ] && export DATA=${FILE}.dat

for mode in ${MODES[@]} ; do
	echo ${FILE} ${mode} ${TV} ${TR}
	time ${PRG} ${DATA} Tv=${TV} Tr=${TR} zmt=${ZMT} task=${mode} detail=2 \
		1> ${FILE}.amp.${mode}.${TV}.${TR} \
		2> ${FILE}.log.${mode}.${TV}.${TR}
done

