#!/bin/csh -f

set PRG = /home/stpark/source/amplitudes/past/source/amplitude.x
set SWP = /home/stpark/source/tools/ued3/pva2amp.x

if( $#argv > 2 ) then
   set MODES = $3
else
   set MODES = ( mode shrink jump walk )
endif

set FCHK = {$1}.fchk
set ZMT  = {$1}.zmt
set FILE = $1
set TAIL = $2
set T    = $2

foreach mode ( $MODES )

 ( $PRG $FCHK $T $ZMT {$mode} > {$FILE}.out.{$mode}.{$TAIL} ) >& {$FILE}.log.{$mode}.{$TAIL}
 ( $SWP swap.dat < {$FILE}.out.{$mode}.{$TAIL} > _amplitudes ) >& _lines
   set L = `cat _lines`
   echo $L[1] $T   >  {$FILE}.amp.{$mode}.{$TAIL}
   cat _amplitudes >> {$FILE}.amp.{$mode}.{$TAIL}
   rm _amplitudes _lines

end

