#!/bin/csh -f

if( $#argv < 2 ) then
	echo "batch.bat header temperature"
	exit
endif

set PRG = ~/source/amplitudes/past/source/amplitude.x

set FILE = $1
set T    = $2
if( $#argv > 2 ) then
   set MODES = $3
else
   set MODES = ( internal shrink jump walk run )
endif

if(-e {$FILE}.dat) then
	set DATA = {$FILE}.dat
else if(-e {$FILE}.fchk) then
	set DATA = {$FILE}.fchk
endif
set ZMT  = {$FILE}.zmt

foreach mode ( $MODES )

 ( $PRG $DATA $T $ZMT {$mode} \
   >  {$FILE}.f{$FROZEN}.amp.{$mode}.{$TAIL} ) \
   >& {$FILE}.f{$FROZEN}.log.{$mode}.{$TAIL}

end

