#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "programming.h"
#include "intrinsic.h"
#include "constantunits.h"

#include "errors.h"
#include "initialize.h"
#include "readgeneric.h"
#include "readfchk.h"
#include "readgdat.h"
#include "readinternal.h"
#include "transformation.h"
#include "cartesian.h"
#include "internal.h"
#include "generateredundant.h"
#include "modeinternal.h"
#include "shrinkage.h"
#include "modewalk.h"

int main(int argc, char *argv[]) 
{
	char nothing[]="";
	char dTv[]="298";
	char dTr[]="298";
	char *suffix=nothing,*sTv=dTv,*sTr=dTr,*sZMT=nothing,*sTask=nothing;
	char *sdGidr=NULL,*sMethod=NULL;

	FILE *fp;
	int i,detail=0;
	int input=GAUSSIAN;

	THERMAL t[1];					// 3 structures declared in programming.h
	INTERNAL h[1];
	CARTESIAN f[1];

	h->curvature=CURVATURE_DGIDR_LINEAR;		// = 4
//	h->dginverse=DGIDR_LINEAR;
	h->dginverse=DGIDR_EXACT;			// = 0
//	h->dginverse=DGIDR_SINGLE;


// read and parse the program input

	if(argc>1)
	{
		for(i=2;i<argc;i++)
		{
			if(!strncmp(argv[i],"-detail",7)) detail++;
			if(!strncmp(argv[i],"detail=",7)) detail=atoi(argv[i]+7);
			if(!strncmp(argv[i],"Tv=",3)) sTv=argv[i]+3;
			if(!strncmp(argv[i],"Tr=",3)) sTr=argv[i]+3;
			if(!strncmp(argv[i],"zmt=",4)) sZMT=argv[i]+4;
			if(!strncmp(argv[i],"task=",5)) sTask=argv[i]+5;
			if(!strncmp(argv[i],"curvature=",10)) sMethod=argv[i]+10;
			if(!strncmp(argv[i],"dgidr=",6)) sdGidr=argv[i]+6;
		}
		if(NULL==(fp=fopen(argv[1],"rt")))
			ued3error(argv[1]);
		else
		{
			suffix=strrchr(argv[1],'.');				// determine the type of input file
			if(!strcmp(suffix,".finp")) input=FINPUT;
			if(!strcmp(suffix,".out")) input=GENERIC;
			if(!strcmp(suffix,".fchk")) input=GAUSSIAN;
			if(!strcmp(suffix,".dat"))  input=GAMESS;
			switch(input)						
			{
				case FINPUT:
					f->na=checkfinp(fp);
					memorycartesianallocate(f);
					readfinp(fp,f,f->na);
					if(detail) writefinp(stderr,f);
					break;
				case GENERIC:
					f->na=checkgeneric(fp);
					memorycartesianallocate(f);
					readgeneric(fp,f,f->na);
					if(detail) writegeneric(stderr,f);
					break;
				case GAUSSIAN:
					f->na=checkfchk(fp);
					memorycartesianallocate(f);
					readfchk(fp,f,f->na);
					if(detail) writefchk(stderr,f);
					break;
				case GAMESS:					// the input is a Gamess dat file 
					f->na=checkgdat(fp);			// check the intput file and read the number of atoms
					memorycartesianallocate(f);		// allocate the memory for the CARTESIAN structure
					readgdat(fp,f,f->na);			// read the input file and assign values to the CARTESIAN structure
					if(detail) writegdat(stderr,f);		// if detail was requested in the input line, then print the coordinates, 
										// gradient,and Hessian to the standard error output
					break;
			}
			fclose(fp);
			if(NULL==(t->Tv=(double *)calloc(f->nc,sizeof(double)))) ued3error("T");	
			assigntemperature(f->nc,t,sTr,sTv);			// assing all the rotational and vibrational temperatures;
										// defined in initialize.c
			if(NULL==(fp=fopen(sZMT,"rt")))
			{
				ued3error(sZMT);
				if(f->na>1) massweightedcartesian(t,f);		// defined in cartesian.c
			}
			else
			{
				readredundant(fp,h);				// read the input file supplied by the user; defined in readinternal.c
				fclose(fp);
				if(detail) writeredundant(stderr,h);
			}
			
			if(sMethod) h->curvature=atoi(sMethod);			// assign the method by which the curvature is calculated
			else fprintf(stderr,"Using default curvature \n");	// = 4
			if(sdGidr) h->dginverse=atoi(sdGidr);			// assign the method by which d(G^-1)/dr is calculated
			else fprintf(stderr,"Using default derivative \n");	// = 0
			if(!strcmp(sTask,"build"))				// print the redundant coordinates to the stderr output 
				generateredundant(f,h);				// using the names supplied int the *.zmt-file
			else
				transform(detail,h,f);				// calculate the transformation tensors and convert
										// the gradient and Hessian matrix to interal redundant coordinates
			
			if(!strcmp(sTask,"internal"))
				modeinternal(detail,t,h);			// harmonic approximation to vibrational amplitudes			
			else if(!strcmp(sTask,"shrunk"))
				shrunk(detail,t,h);
			else if(!strcmp(sTask,"shrink"))
				shrink(detail,t,h);
			else if(!strcmp(sTask,"jump"))
				modejump(detail,t,h);
			else if(!strcmp(sTask,"walk"))
				modewalk(detail,t,h);
			else if(!strcmp(sTask,"run"))
				moderun(detail,t,h);
			else if(!strcmp(sTask,"build"))
				fprintf(stderr,"built redundant internal coordinates\n");
			else
				ued3error("specify mode");

			memoryinternalfree(h);					// Free memory
			memorycartesianfree(f);
			free(t->Tv);
		}
	}
	else
	{
		fprintf(stderr,"UnitWeight= %le kg\n",UnitWeight);
		fprintf(stderr,"UnitLength= %le m\n",UnitLength);
		fprintf(stderr,"UnitEnergy= %le J\n",UnitEnergy);
		fprintf(stderr,"UnitTime= %le s\n",UnitTime);
		fprintf(stderr,"\n");
		fprintf(stderr,"h = %le Energy Time\n",PlanckConstant);
		fprintf(stderr,"k = %le Energy / Temperature\n",BoltzmannConstant);
		fprintf(stderr,"c = %le Length / Time\n",SpeedLight);
		fprintf(stderr,"\n");
		fprintf(stderr,"DataLength= %le UnitLength\n",DataUnitLength);
		fprintf(stderr,"DataEnergy= %le UnitEnergy\n",DataUnitEnergy);
		fprintf(stderr,"\n");
		fprintf(stderr,"InputWeight= %le UnitWeight\n",InputUnitWeight);
		fprintf(stderr,"InputLength= %le UnitLength\n",InputUnitLength);
		fprintf(stderr,"InputTime= %le UnitTime\n",InputUnitTime);
		fprintf(stderr,"\n");
		fprintf(stderr,"usage: %s data [-detail] [Tv=+value/-file] [Tr=+value/-file] [zmt=file] [task=build/internal/shrunk/shrink/jump/walk/run] [curvature=#]\n",argv[0]);
	}
	return(0);
}

