#include "physicalconstants.h"

#define DataUnitLength		(SI_BohrRadius/UnitLength)	// program = data * DataUnitLength
#define DataUnitEnergy		(SI_Hartree/UnitEnergy)
#define DataUnitGradient	(DataUnitEnergy/DataUnitLength)
#define DataUnitHessian		(DataUnitGradient/DataUnitLength)

#define InputWeight		(1.0E-03/SI_AvogadroNumber)	// amu in kg
#define InputLength		(1.0E-10)			// A in m
#define InputTime		(1.0E-09)			// ns in s
#define InputAngle		(M_PI/180)

#define InputUnitWeight		(InputWeight/UnitWeight)
#define InputUnitLength		(InputLength/UnitLength)
#define InputUnitTime		(InputTime/UnitTime)
#define InputUnitFrequency	(1/InputUnitTime)
#define InputUnitTemperature	(1/UnitTemperature)

#define InputUnitSpeed		(InputUnitLength/InputUnitTime)
#define InputUnitMomentum	(InputUnitWeight*InputUnitSpeed)

#define AMU			((1.0E-03/SI_AvogadroNumber)/UnitWeight)
#define Bohr			(SI_BohrRadius/UnitLength)
#define Angstrom		(1.0E-10/UnitLength)
#define Hartree			(SI_Hartree/UnitEnergy)
#define GigaHerz		(1.0E+09/(1.0/UnitTime))
#define PerCentimeter		(1.0E+02/(1.0/UnitLength))
#define Kelvin			(1.0E+00/UnitTemperature)
#define AMUAngstrom2		(AMU*Angstrom*Angstrom)
#define SqrtAMU			(sqrt(AMU))
#define SqrtAMUAngstrom		(SqrtAMU*Angstrom)

#define hc			(PlanckConstant*SpeedLight)

#define hc_2k	(PlanckConstant*SpeedLight/(2*BoltzmannConstant))	
#define h_8pi2c	(PlanckConstant/(8*M_PI*M_PI*SpeedLight))
#define h2_8pi2	(PlanckConstant*PlanckConstant/(8*M_PI*M_PI))

#define EU_CM	(1/(hc*UnitLength*1.0E+02))
#define Bohr_Angstrom		(Bohr/Angstrom)

