#include <stdio.h>
#include <stdlib.h>
#include "constantunits.h"
#include "programming.h"
#include "interface.h"
#include "errors.h"

void printmoldenforce(INTERNAL *h,double *dvt)
{
	int i;
	fprintf(stderr,"[Molden Format]\n");
	fprintf(stderr,"[ATOMS] Angs\n");
	for(i=0;i<h->na;i++)
		fprintf(stderr," %c %5d%3d %12.8lf %12.8lf %12.8lf\n",*(h->ai[i].name),i+1,h->an[i]
			,h->cc[i*3]/Angstrom,h->cc[i*3+1]/Angstrom,h->cc[i*3+2]/Angstrom);
	fprintf(stderr,"[FR-COORD]\n");
	for(i=0;i<h->na;i++)
		fprintf(stderr," %c %lf %lf %lf\n",*(h->ai[i].name)
			,h->cc[i*3]/Angstrom,h->cc[i*3+1]/Angstrom,h->cc[i*3+2]/Angstrom);
}

void printmoldenfrequency(int i,INTERNAL *h,double *fr,double *dvt)
{
	int j;
	double *fx;
	if(NULL==(fx=(double *)calloc(h->nc,sizeof(double)))) ued3error("lack of memory");

	fprintf(stderr,"[Molden Format]\n");
	fprintf(stderr,"[GEOMETRIES] XYZ\n");
	fprintf(stderr,"%5d\n\n",h->na);
	for(j=0;j<h->na;j++)
		fprintf(stderr," %c %12.6lf %12.6lf %12.6lf\n",*(h->ai[j].name)
			,h->cc[j*3]/Angstrom,h->cc[j*3+1]/Angstrom,h->cc[j*3+2]/Angstrom);

	fprintf(stderr,"[FREQ]\n");
	fprintf(stderr," 1000.0000\n");
	fprintf(stderr," 2000.0000\n");
	fprintf(stderr," 3000.0000\n");

	fprintf(stderr,"[INT]\n");
	fprintf(stderr,"  100.0000     0.0000\n");
	fprintf(stderr,"  200.0000     0.0000\n");
	fprintf(stderr,"  300.0000     0.0000\n");

	fprintf(stderr,"[FR-COORD]\n");
	for(j=0;j<h->na;j++)
		fprintf(stderr," %c %12.6lf %12.6lf %12.6lf\n",*(h->ai[j].name)
			,h->cc[j*3]/Bohr,h->cc[j*3+1]/Bohr,h->cc[j*3+2]/Bohr);
	
	fprintf(stderr,"[FR-NORM-COORD]\n");
	fprintf(stderr,"vibration     1\n");
	for(j=0;j<h->na;j++)
		fprintf(stderr,"%12.6lf %12.6lf %12.6lf\n"
			,h->vx[j*3]/Bohr,h->vx[j*3+1]/Bohr,h->vx[j*3+2]/Bohr);
	fDGEMV('N',h->nc,h->nr,1.0,h->bi,h->nc,fr,1,0.0,fx,1);
	fprintf(stderr,"vibration     2\n");
	for(j=0;j<h->na;j++)
		fprintf(stderr,"%12.6lf %12.6lf %12.6lf\n"
			,fx[j*3]/Bohr,fx[j*3+1]/Bohr,fx[j*3+2]/Bohr);
	fDGEMV('N',h->nc,h->nr,1.0,h->bi,h->nc,dvt,1,0.0,fx,1);
	fprintf(stderr,"vibration     3\n");
	for(j=0;j<h->na;j++)
		fprintf(stderr,"%12.6lf %12.6lf %12.6lf\n"
			,fx[j*3]/Bohr,fx[j*3+1]/Bohr,fx[j*3+2]/Bohr);

	free(fx);
	return;
}
