#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "constantunits.h"
#include "intrinsic.h"
#include "programming.h"

#include "errors.h"
#include "coordinates.h"
#include "cartesian.h"
#include "atomic.h"
#include "generateredundant.h"


// The following function prints out all unique bond distances and all directly bonded angles and dihedral angles
// using the atomic names specified by the user in the *.zmt-file

int generateredundant(CARTESIAN *f,INTERNAL *h)
{
	int detail=1;
	int i,j,k,l,n=0;
	int *b,*c;
	double r,d,ri,rj,*bt;
	fprintf(stderr," generating redundant coordinate system\n");
	if(NULL==(b=(int *)calloc(f->na*f->na,sizeof(int))))
		ued3error("lack of memory");
	if(NULL==(c=(int *)calloc(f->na,sizeof(int))))
		ued3error("lack of memory");
	if(NULL==(bt=(double *)calloc(3*f->na,sizeof(double))))
		ued3error("lack of memory");

	fprintf(stdout,"\n\n");
	for(i=1;i<f->na;i++)
		for(j=0;j<i;j++)
		{
			r=distance(i,j,f->cc,bt);		// generate all unique interatomic distances
			ri=atomicradius(f->an[i]);
			rj=atomicradius(f->an[j]);
			d=1.3*(ri+rj);
		//	if(r/Angstrom>1.85*(1+0.084*sqrt(f->an[i]*f->an[j]/36))) 
			if(r>d)
			{
				fprintf(stderr," %5d %5d r= %lf > d= %lf = 1.3 * ( %lf + %lf )\n",i+1,j+1,r,d,ri,rj);
			}
		//	else if((1==f->an[i])&&(1==f->an[j]))
		//	{
		//		//fprintf(stderr," %5d %5d d= %lf\n",i+1,j+1,r);
		//	}
			else
			{
			//	fprintf(stderr,"%5d %5d %5d r= %12.8lf\n",BOND_RECIPROCAL2,i+1,j+1,r);
				fprintf(stdout,"%-5s %-5s %-5s %10.5lf \tr= %12.8lf\n","r",h->ai[i].name,h->ai[j].name,2.0,r);
				b[rindex(i,j,f->na,f->na)]=1;	//mark the direct bond distances
				b[rindex(j,i,f->na,f->na)]=1;
				c[i]++;
				c[j]++;
			}
		}
	fprintf(stdout,"\n");

//	for(j=0;j<f->na;j++)
//		fprintf(stderr,"$$$ %5d has %d bonding(s)\n",j+1,c[j]);
//	fprintf(stderr,"\n");

	for(j=0;j<f->na;j++)
	{
		if(c[j]>1)					// atom j is directly bonded
		{
			for(i=1;i<f->na;i++)
			for(k=0;k<i;k++)
			{
				if(b[rindex(i,j,f->na,f->na)]&&b[rindex(j,k,f->na,f->na)])
				{
					r=180/M_PI*bending(i,j,k,f->cc,bt); 		// assign the bending angle in degrees
				//	fprintf(stderr,"%5d %5d %5d %5d a= %12.6lf\n",BENDING_ANGLE,i+1,j+1,k+1,r);
					fprintf(stdout,"%-5s %-5s %-5s %-5s %10.5lf \ta= %12.6lf\n","a",h->ai[i].name,h->ai[j].name,h->ai[k].name,0.0,r);
				}
			}
		}
	}
	fprintf(stdout,"\n");

	for(j=1;j<f->na;j++)
		for(k=0;k<j;k++)
			if(b[rindex(j,k,f->na,f->na)])
			{
				for(i=0;i<f->na;i++)
					for(l=0;l<f->na;l++)
					{
						if((i!=k)&&(j!=l)&&(i!=l)&&b[rindex(i,j,f->na,f->na)]&&b[rindex(k,l,f->na,f->na)])
						{
							r=180/M_PI*dihedral(i,j,k,l,f->cc,bt);
						//	fprintf(stderr,"%5d %5d %5d %5d %5d d= %12.6lf\n",DIHEDRAL_ANGLE,i+1,j+1,k+1,l+1,r);
							fprintf(stdout,"%-5s %-5s %-5s %-5s %-5s %10.5lf \td= %12.6lf\n","d",h->ai[i].name,h->ai[j].name,h->ai[k].name,h->ai[l].name,0.0,r);
						}
					}
			}
	fprintf(stdout,"\n\n");

	free(bt);
	free(c);
	free(b);
	return(n);				// return value is zero
}

