// Refer to the math kernel library manual for details on these functions


// Computes a vector vector dot product

double fDDOT(int n,double *x,int incx,double *y,int incy)
{
	extern double ddot_(int *n,double *x,int *incx,double *y,int *incy);
	return(ddot_(&n,x,&incx,y,&incy));
}


// Sets an n-vector x equal to the zero vector 

void fDCLEAR(int n,double *x,int incx)
{
//	extern double dclear_(int *n,double *x,int *incx);
//	dclear_(&n,x,&incx);
	int i;
	for(i=0;i<n;i++)
		x[i*incx]=0;
	return;
}


// Copies vector x to another vector y

void fDCOPY(int n,double *x,int incx,double *y,int incy)
{
	extern void dcopy_(int *n,double *x,int *incx,double *y,int *incy);
	dcopy_(&n,x,&incx,y,&incy);
	return;
}


// Performs a vector-vector operation defined as
// y := a*x + y, where a is a scalar

void fDAXPY(int n,double a,double *x,int incx,double *y,int incy)
{
	extern void daxpy_(int *n,double *a,double *x,int *incx,double *y,int *incy);
	daxpy_(&n,&a,x,&incx,y,&incy);
	return;
}


// Computes a matrix-vector product using a general matrix
// y := alpha*A*x + beta*y,

void fDGEMV(char trans,int m,int n,double alpha,double *a,int lda,double *x,int incx,double beta,double *y,int incy)
{
	extern void dgemv_(char *trans,int *m,int *n,double *alpha,double *a,int *lda,double *x,int *incx,double *beta,double *y,int *incy);
	dgemv_(&trans,&m,&n,&alpha,a,&lda,x,&incx,&beta,y,&incy);
	return;
}

void fDSYEV(char jobz,char uplo,int n,double *a,int lda,double *w,double *lwork,int *info)
{
	extern void dsyev_(char *jobz,char *uplo,int *n,double *a,int *lda,double *w,double *lwork,int *info);
	dsyev_(&jobz,&uplo,&n,a,&lda,w,lwork,info);
	return;
}


// Computes all eigenvalues and, optionally,eigenvectors of a real symmetric matrix in packed storage.

void fDSPEV(char jobz,char uplo,int n,double *ap,double *w,double *z,int ldz,double *work,int *info)
{
	extern void dspev_(char *jobz,char *uplo,int *n,double *ap,double *w,double *z,int *ldz,double *work,int *info);
	dspev_(&jobz,&uplo,&n,ap,w,z,&ldz,work,info);
	return;
}


// Computes a scalar-matrix-matrix product and adds the result to a scalar-matrix product.
// C = alpha*op(A)*op(B) + beta*C

void fDGEMM(char transa,char transb,int m,int n,int k,double alpha,double *a,int lda,double *b,int ldb,double beta,double *c,int ldc)
{
	extern void dgemm_(char *transa,char *transb,int *m,int *n,int *k,double *alpha,double *a,int *lda,double *b,int *ldb,double *beta,double *c,int *ldc);
	dgemm_(&transa,&transb,&m,&n,&k,&alpha,a,&lda,b,&ldb,&beta,c,&ldc);
	return;
}

void fDTRMM (char side,char uplo,char transa,char diag,int m,int n,double alpha,double *a,int lda,double *b,int ldb)
{
	extern void dtrmm_(char *side,char *uplo,char *transa,char *diag,int *m,int *n,double *alpha,double *a,int *lda,double *b,int *ldb);
	dtrmm_(&side,&uplo,&transa,&diag,&m,&n,&alpha,a,&lda,b,&ldb);
	return;
}

void fDTRSM (char side,char uplo,char transa,char diag,int m,int n,double alpha,double *a,int lda,double *b,int ldb)
{
	extern void dtrsm_(char *side,char *uplo,char *transa,char *diag,int *m,int *n,double *alpha,double *a,int *lda,double *b,int *ldb);
	dtrsm_(&side,&uplo,&transa,&diag,&m,&n,&alpha,a,&lda,b,&ldb);
	return;
}

void fDPOTRF (char uplo,int n,double *a,int lda,int *info)
{
	extern void dpotrf_(char *uplo,int *n,double *a,int *lda,int *info);
	dpotrf_(&uplo,&n,a,&lda,info);
	return;
}

void fDPOTRI (char uplo,int n,double *a,int lda,int *info)
{
	extern void dpotri_(char *uplo,int *n,double *a,int *lda,int *info);
	dpotri_(&uplo,&n,a,&lda,info);
	return;
}

