#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "atomic.h"
#include "constantunits.h"
#include "programming.h"

#include "errors.h"
#include "outputs.h"
#include "interface.h"
#include "coordinates.h"
#include "cartesian.h"
#include "calculate.h"
#include "internal.h"

#include "modeinternal.h"




int modeinternal(int detail,THERMAL *t,INTERNAL *h)
{
	int i,j,k,m,nx=6,nz=h->nr-h->nv;	// nz: number of redundancies
	double *bt=NULL;
	double Ti,r,v,rg,l2,l1,l2sum,frequency,wavenumber;

	rg=fDDOT(h->nr,h->gr,1,h->gr,1);	
	fprintf(stderr," rms cartesian gradient is %le hartree/bohr^2\n",sqrt(rg/h->nr)/(Hartree/Bohr/Bohr));
	nx=normalmode(detail,h);
	//fDGEMM('N','N',h->nc,h->nr,h->nc,1.0,f->rm_matrix,h->nc,vz,h->nc,0.0,vg,h->nc);

	if(NULL==(bt=(double *)calloc(3*h->na,sizeof(double)))) ued3error("lack of memory");

	for(i=0;i<nz;i++)	// the first modes correspond to the redundancies (eigenvalues should be (numerically) zero)
	{
		if(i-h->nr+h->nc<6) Ti=298;				// assign a generic temperature to these redundant modes
		else Ti=t->Tv[i-h->nr+h->nc];
		frequency=sqrt(fabs(h->ev[i]))*(0.5*M_1_PI);
		wavenumber=frequency/(SpeedLight);
		fprintf(stderr,"%5d: %12.3lf GHz %12.4lf /cm from %16.7le\n"
 			,i+1,frequency/GigaHerz,wavenumber/PerCentimeter,h->ev[i]);
 		fprintf(stderr,"\n");
 	}
	for(i=nz;i<h->nr;i++)	// the remaining modes are the vibrational normal modes
	{
		if(i-h->nr+h->nc<6) Ti=298;
		else Ti=t->Tv[i-h->nr+h->nc];				// assign them the vibrational temperature
		frequency=sqrt(fabs(h->ev[i]))*(0.5*M_1_PI);
		wavenumber=frequency/(SpeedLight);
		fprintf(stderr,"%5d: %12.3lf GHz %12.4lf /cm from %16.7le  "
 			,i+1,frequency/GigaHerz,wavenumber/PerCentimeter,h->ev[i]);
 		l2=h_8pi2c/(wavenumber*tanh(hc_2k*wavenumber/Ti));	// calculate the mean amplitude of vibration
	//	if(eigenvalue[i]>1E-6)
 	//		fprintf(stderr,"l= %lf sqrt(amu) A at %lf K",sqrt(l2),t);
 		fprintf(stderr,"l= %lf sqrt(amu) A at %lf K",sqrt(l2)/SqrtAMUAngstrom,Ti/Kelvin);
 		fprintf(stderr,"\n");
		if(detail)	// print out the eigenvector corresponding to the eigenvalue
		{
			formattedvector(h->nr,h->vq+rindex(0,i,h->nr,h->nr),"vq");
			formattedvector(h->nr,h->vr+rindex(0,i,h->nr,h->nr),"vr");
			formattedvector(h->nc,h->vx+rindex(0,i,h->nc,h->nr),"vx");
		}
 	}
 	fprintf(stderr,"\n");


	fprintf(stdout,"%8d",h->na*(h->na-1)/2);		// number of unique internuclear distances
	for(i=nz;i<h->nr;i++)					// print the temperature for all normal modes of vibration
		fprintf(stdout,"  %.0lf",t->Tv[i-nz]);		
	fprintf(stdout,"\n");
	for(k=1;k<h->na;k++)
		for(j=0;j<k;j++)
		{
			l2sum=0;
			fDCLEAR(h->nc,bt,1);			// initialize bt to the zero vector
			m=mindex(j,k);
			r=distance(j,k,h->cc,bt);		// internuclear distance, bt is a unit vector pointing toward the other nucleus
			for(i=nz;i<h->nr;i++)
			{
				Ti=t->Tv[i-nz];
				frequency=sqrt(fabs(h->ev[i]))*(0.5*M_1_PI);
				wavenumber=frequency/(SpeedLight);
				l2=h_8pi2c/(wavenumber*tanh(hc_2k*wavenumber/Ti));
				l1=sqrt(l2);
				v=fDDOT(h->nc,bt,1,h->vx+rindex(0,i,h->nc,h->nr),1);	// project each eigenvector onto the internuclear distance vector
				l2sum+=l2*v*v;						// amplitude-weighted internuclear vibration,
											// see Hargittai, Stereochemical Applications, 1988, pp. 143
			}
			fprintf(stdout," %-6s%-6s",h->ai[j].name,h->ai[k].name);	// print parameters to file
			fprintf(stdout,"  re= %15.10lf",r/Angstrom);
			fprintf(stdout,"  lh= %13.10lf",sqrt(l2sum)/Angstrom);
			fprintf(stdout,"\n");
		}
 
	free(bt);
	return(h->nr);
}

int internalamplitudes(THERMAL *t,INTERNAL *h)
{
 	return(h->nr);
}

