#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "programming.h"

#include "errors.h"
#include "outputs.h"
#include "interface.h"
#include "calculate.h"

int calculatecurvature(int detail,INTERNAL *h)
{
	int i,j,k;
	double *btp=NULL,*btn=NULL,*x=NULL,*r=NULL,s;

	if(NULL==(btp =(double *)calloc(h->nc*h->nr,sizeof(double)))) ued3error("lack of memory");
	if(NULL==(btn =(double *)calloc(h->nc*h->nr,sizeof(double)))) ued3error("lack of memory");
	if(NULL==(x  =(double *)calloc(h->nc,sizeof(double)))) ued3error("lack of memory");
	if(NULL==(r  =(double *)calloc(h->nr,sizeof(double)))) ued3error("lack of memory");

	for(k=0;k<h->nc;k++)
	{
		fDCOPY(h->nc,h->cc,1,x,1);
		x[k]+= DIFFSTEP;
		calculatebtmatrix(h->nr,h->nc,h->z,r,x,btp);
		//calculatetranspose(nc,nr,bt,b);
		fDCOPY(h->nc,h->cc,1,x,1);
		x[k]-= DIFFSTEP;
		calculatebtmatrix(h->nr,h->nc,h->z,r,x,btn);
		//calculatetranspose(nc,nr,bt,b);
		for(i=0;i<h->nr;i++)
			for(j=0;j<h->nc;j++)
				h->ct[cindex(k,j,i,h->nc,h->nc,h->nr)]
				 =(btp[rindex(j,i,h->nc,h->nr)]-btn[rindex(j,i,h->nc,h->nr)])
				  /(2*DIFFSTEP);
	}
	for(i=0;i<h->nr;i++)
		for(j=1;j<h->nc;j++)
			for(k=0;k<j;k++)
			{
				s = (h->ct[cindex(k,j,i,h->nc,h->nc,h->nr)]+h->ct[cindex(j,k,i,h->nc,h->nc,h->nr)])/2;
				h->ct[cindex(k,j,i,h->nc,h->nc,h->nr)] = s;
				h->ct[cindex(j,k,i,h->nc,h->nc,h->nr)] = s;
			}

	free(r);
	free(x);
	free(btn);
	free(btp);
	return(0);
}

