#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "programming.h"

#include "errors.h"

void printrtensor(int n,int m,int l,double *t)
{
	int i,j,k;
	for(i=0;i<l;i++)
	{
		fprintf(stderr,"depth= %d\n",i+1);
		for(j=0;j<m;j++)
		{
			for(k=0;k<n;k++)
				fprintf(stderr,"%8.4lf",t[cindex(i,j,k,l,m,n)]);
			fprintf(stderr,"\n");
		}
		fprintf(stderr,"\n");
	}
	fprintf(stderr,"\n");
	return;
}

void printttensor(int n,int m,int l,double *t)
{
	int i,j,k;
	for(i=0;i<l;i++)
	{
		fprintf(stderr,"depth= %d\n",i+1);
		for(j=0;j<m;j++)
		{
			for(k=0;k<n;k++)
				fprintf(stderr,"%8.4lf",t[cindex(k,j,i,n,m,l)]);
			fprintf(stderr,"\n");
		}
		fprintf(stderr,"\n");
	}
	fprintf(stderr,"\n");
	return;
}


// Print the rectangular m(rows) x n(columns) matrix

void printrectangularmatrix(int m,int n,double *a)	// row-major
{
	int i,j;
	for(i=0;i<m;i++)
	{
		for(j=0;j<n;j++)
			fprintf(stderr,"%8.4lf",a[rindex(i,j,m,n)]);
		fprintf(stderr,"\n");
	}
	fprintf(stderr,"\n");
	return;
}

void printtriangularmatrix(int m,int n,double *a)
{
	int i,j;
	for(j=0;j<m;j++)
	{
		for(i=0;i<=j;i++)
			fprintf(stderr,"%8.4lf",a[uindex(i,j)]);
		fprintf(stderr,"\n");
	}
	fprintf(stderr,"\n");
	return;
}


// The following function prints out the components of an n-vector v named s

int formattedvector(int n,double *v,char *s)
{
	int j;
	fprintf(stderr," %-4s = ",s);
	for(j=0;j<n;j++)
		fprintf(stderr,"%8.4lf",v[j]);
	fprintf(stderr,"\n");
	return(0);
}

int formatteddisplacedvector(int n,double l,double *u,double *v,char *s)
{
	int j;
	fprintf(stderr," %s at %lf = ",s,l);
	for(j=0;j<n;j++)
		fprintf(stderr,"%8.4lf",v[j]+l*u[j]);
	fprintf(stderr,"\n");
	return(0);
}

