#include <math.h>

// #define UNIT_ATOMIC
#define UNIT_MOLECULAR
// MKS unit has problem with comparing distance(m) and angle(rad)

// Physical constants in standard unit (MKS)
// NIST Fundamental Physical Constants 2002

#define SI_AvogadroNumber	(6.0221415e+23)
#define SI_SpeedLight		(2.99792458e+08) 	// c (m s^-1)
#define SI_PlanckConstant	(6.6260693e-34) 	// h (J s)
#define SI_BoltzmannConstant	(1.3806505e-23)		// k (J K^-1)
#define SI_ElectronCharge	(1.60217653e-19) 	// e (C)
#define SI_ElectronMass		(9.1093826e-31)		// me (kg)
#define SI_VacuumPermittivity	(8.854187817e-12)	// e0 (F/m = C/V/m)
#define SI_VaccumPermeability	(4e-7*M_PI) 		// u0 (N/A^2) , 1/c^2=e0u0

#define SI_BohrRadius		(0.5291772108e-10)	// Bohr
#define SI_hbar			(SI_PlanckConstant/(2*M_PI)) 	// hbar (J s)
#define SI_Hartree		(SI_hbar*SI_hbar/(SI_ElectronMass*SI_BohrRadius*SI_BohrRadius))	// Hartree

// Programming Units

#if (defined(UNIT_DIFFRACTIONAL))
	#define UnitNumber	(1.0)				// molecule
	#define UnitWeight	(SI_ElectronMass)		// me
	#define UnitLength	(1.0E-03)			// mm
	#define UnitTime	(1.0E-12)			// ps
	#define UnitCharge	(SI_ElectronCharge)		// e
	#define UnitTemperature (300.)				// RT
#elif (defined(UNIT_ATOMIC))
	#define UnitNumber	(1.0)				// molecule
	#define UnitWeight	(SI_ElectronMass)		// me
	#define UnitLength	(SI_BohrRadius)			// Bohr
	#define UnitCharge	(SI_ElectronCharge)		// e
//	#define UnitEnergy	(SI_Hartree)			// Hartree
	#define UnitTime	(SI_hbar/SI_Hartree)		// time is dervied from energy
//	#define CoulombConstant	(1/(4*M_PI*SI_VacuumPermittivity))
	#define UnitTemperature (SI_Hartree/SI_BoltzmannConstant)				// RT
#elif (defined(UNIT_MOLECULAR))
	#define UnitNumber	(1.0)				// molecule
	#define UnitWeight	(1.0E-03/SI_AvogadroNumber)	// amu
	#define UnitLength	(1.0E-10)			// angstrom
	#define UnitTime	(1.0E-15)			// fs 
	#define UnitCharge	(SI_ElectronCharge)		// e
	#define UnitTemperature (1.0)				// RT
#else	// using MKS
	#define UnitNumber	(1.0)
	#define UnitWeight	(1.0)
	#define UnitLength	(1.0)
	#define UnitTime	(1.0)
	#define UnitCharge	(1.0)
	#define UnitTemperature (1.0)
#endif

// derived units

#define UnitArea		( UnitLength*UnitLength )		// m^2
#define UnitVolume		( UnitLength*UnitLength*UnitLength )	// m^3
#define UnitSpeed		( UnitLength/UnitTime )			// m/s
#define UnitMomentum		( UnitWeight*UnitSpeed )		// kg m/s
#define UnitEnergy		( UnitWeight*UnitSpeed*UnitSpeed )	// J = kg m^2/s^2
#define UnitForce		( UnitEnergy/UnitLength )		// N = kg m/s^2
#define UnitVoltage		( UnitEnergy/UnitCharge )		// V = J/C
#define UnitCurrent		( UnitCharge/UnitTime )			// A = C/s
//#define UnitMagneticFluxDensity	( UnitWeight/(UnitTime*UnitCharge) )	// T = N/A/m
#define UnitMagneticFluxDensity	( UnitForce/(UnitCurrent*UnitLength) )	// T = N/A/m
// 1 T = 1 kg s^-2 A^-1 = 1 N A^−1 m^−1 = 1 kg s^−1 C^−1
//     = SI derived unit of magnetic flux density (B)
// 1 T = 10^4 G (gauss)
// [B] = [v] X 1/c^2 [E]

// Physical Constants redefined in Programming unit, some are normalized when au is used

#define AvogadroNumber		( SI_AvogadroNumber / UnitNumber )
#define SpeedLight		( SI_SpeedLight / UnitSpeed )
#define PlanckConstant		( SI_PlanckConstant / ( UnitEnergy * UnitTime ) )
#define BoltzmannConstant	( SI_BoltzmannConstant / UnitEnergy * UnitTemperature )
#define ElectronCharge		( SI_ElectronCharge / UnitCharge )
#define ElectronMass		( SI_ElectronMass / UnitWeight )
#define VacuumPermittivity	( SI_VacuumPermittivity / UnitCharge * UnitVoltage * UnitLength )
#define VaccumPermeability	( SI_VaccumPermeability / UnitForce * UnitCurrent * UnitCurrent )

